package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.generalclients.ClientRestrictionEnum;
import com.yandex.direct.api.v5.generalclients.ClientRestrictionItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 10/02/16.
 */
public class ClientRestrictionItemMap extends ModelBeanMap<ClientRestrictionItemMap> {

    public static final String ELEMENT = "element";
    public static final String VALUE = "value";

    public ClientRestrictionItemMap() {
        super();
        setBean(new ClientRestrictionItem());
    }

    public ClientRestrictionItemMap(ClientRestrictionItem limit) {
        super();
        setBean(limit);
    }

    public ClientRestrictionItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ClientRestrictionItemMap withElement(ClientRestrictionEnum element) {
        this.put(ELEMENT, element);
        return this;
    }

    public ClientRestrictionItemMap withValue(int value) {
        this.put(VALUE, value);
        return this;
    }
}
