package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingAddEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingAddItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


public class ClientSettingAddItemMap extends ModelBeanMap<ClientSettingAddItemMap> {
    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public ClientSettingAddItemMap() {
        this(new ClientSettingAddItem());
    }

    public ClientSettingAddItemMap(ClientSettingAddEnum option, YesNoEnum value) {
        this();
        this.withOption(option).withValue(value);
    }

    public ClientSettingAddItemMap(ClientSettingAddItem item) {
        super();
        setBean(item);
    }

    public ClientSettingAddItemMap withOption(ClientSettingAddEnum element) {
        return put(OPTION, element);
    }

    public ClientSettingAddItemMap withValue(YesNoEnum value) {
        return put(VALUE, value);
    }
}
