package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingGetEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingGetItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


public class ClientSettingGetItemMap extends ModelBeanMap<ClientSettingGetItemMap> {
    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public ClientSettingGetItemMap() {
        this(new ClientSettingGetItem());
    }

    public ClientSettingGetItemMap(ClientSettingGetItem settings) {
        super();
        setBean(settings);
    }

    public ClientSettingGetItemMap(ClientSettingGetEnum element, YesNoEnum value) {
        this();
        withOption(element).withValue(value);
    }

    public ClientSettingGetItemMap withOption(ClientSettingGetEnum element) {
        return put(OPTION, element);
    }

    public ClientSettingGetItemMap withValue(YesNoEnum value) {
        return put(VALUE, value);
    }
}
