package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.EmailSubscriptionEnum;
import com.yandex.direct.api.v5.generalclients.EmailSubscriptionItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by hmepas on 15.04.16.
 */

public class EmailSubscriptionItemMap extends ModelBeanMap<EmailSubscriptionItemMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public EmailSubscriptionItemMap() {
        this(new EmailSubscriptionItem());
    }

    public EmailSubscriptionItemMap(EmailSubscriptionItem emailSubscriptionItem) {
        super();
        setBean(emailSubscriptionItem);
    }

    public EmailSubscriptionItemMap(EmailSubscriptionEnum option, YesNoEnum value) {
        this();
        this.withOption(option).withValue(value);
    }

    public EmailSubscriptionItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public EmailSubscriptionItemMap withOption(EmailSubscriptionEnum option) {
        this.put(OPTION, option);
        return this;
    }

    public EmailSubscriptionItemMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
