package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.GrantGetItem;
import com.yandex.direct.api.v5.generalclients.PrivilegeEnum;


public class GrantGetItemMap extends GrantItemMap<GrantGetItemMap> {
    public static final String AGENCY = "agency";

    public GrantGetItemMap() {
        this(new GrantGetItem());
    }

    public GrantGetItemMap(GrantGetItem grant) {
        super();
        setBean(grant);
    }

    public GrantGetItemMap(String agency, PrivilegeEnum privilege, YesNoEnum value) {
        this();
        withAgency(agency).withPrivilege(privilege).withValue(value);
    }

    public GrantGetItemMap withAgency(String agency) {
        return put(AGENCY, agency);
    }
}
