package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.GrantItem;
import com.yandex.direct.api.v5.generalclients.PrivilegeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 10/02/16.
 */
public class GrantItemMap<T extends GrantItemMap> extends ModelBeanMap<T> {
    public static final String PRIVILEGE = "privilege";
    public static final String VALUE = "value";

    public GrantItemMap() {
        this(new GrantItem());
    }

    public GrantItemMap(GrantItem grant) {
        super();
        setBean(grant);
    }

    public GrantItemMap(PrivilegeEnum privilege, YesNoEnum value) {
        this();
        withPrivilege(privilege).withValue(value);
    }

    public T withPrivilege(PrivilegeEnum privilege) {
        return put(PRIVILEGE, privilege);
    }

    public T withValue(YesNoEnum value) {
        return put(VALUE, value);
    }
}
