package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.LangEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.EmailSubscriptionEnum;
import com.yandex.direct.api.v5.generalclients.NotificationAdd;

public class NotificationAddMap extends NotificationMap<NotificationAddMap> {

    public static final String DEFAULT_EMAIL = "xxx@xxx.ru";
    public static final LangEnum DEFAULT_LANG = LangEnum.RU;

    public NotificationAddMap() {
        this(new NotificationAdd());
    }

    public NotificationAddMap(NotificationAdd notification) {
        super();
        setBean(notification);
    }

    public NotificationAddMap withDefault() {
        withEmail(DEFAULT_EMAIL);
        withLang(DEFAULT_LANG);
        withEmailSubscriptions(
                new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS, YesNoEnum.YES));
        return this;
    }
}
