package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.LangEnum;
import com.yandex.direct.api.v5.generalclients.Notification;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 10/02/16.
 */
public class NotificationMap<T extends NotificationMap> extends ModelBeanMap<T> {
    public static final String LANG = "lang";
    public static final String EMAIL = "email";
    public static final String EMAIL_SUBSCRIPTIONS = "emailSubscriptions";

    public NotificationMap() {
        this(new Notification());
    }

    public NotificationMap(Notification notification) {
        super();
        setBean(notification);
    }

    public T withLang(LangEnum lang) {
        return put(LANG, lang);
    }

    public T withEmail(String email) {
        return put(EMAIL, email);
    }

    public T withEmailSubscriptions(EmailSubscriptionItemMap... emailSubscriptions) {
        return putBeanMapList(EMAIL_SUBSCRIPTIONS, emailSubscriptions);
    }
}
