package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.general.RepresentativeRoleEnum;
import com.yandex.direct.api.v5.generalclients.Representative;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 10/02/16.
 */
public class RepresentativeMap extends ModelBeanMap<RepresentativeMap> {

    public static final String LOGIN = "login";
    public static final String EMAIL = "email";
    public static final String ROLE = "role";

    public RepresentativeMap() {
        super();
        setBean(new Representative());
    }

    public RepresentativeMap(Representative representative) {
        super();
        setBean(representative);
    }

    public RepresentativeMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RepresentativeMap withLogin(String login) {
        this.put(LOGIN, login);
        return this;
    }

    public RepresentativeMap withEmail(String email) {
        this.put(EMAIL, email);
        return this;
    }

    public RepresentativeMap withRole(RepresentativeRoleEnum role) {
        this.put(ROLE, role);
        return this;
    }

}
