package ru.yandex.autotests.directapi.model.api5.keywordbids;

import java.util.Arrays;

import com.yandex.direct.api.v5.keywordbids.GetRequest;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String SEARCH_FIELD_NAMES = "searchFieldNames";
    public static final String NETWORK_FIELD_NAMES = "networkFieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap withSelectionCriteria(KeywordBidsSelectionCriteriaMap selectionCriteria) {
        return putBeanMap(SELECTION_CRITERIA, selectionCriteria);
    }

    public GetRequestMap withFieldNames(KeywordBidFieldEnum... fieldNames) {
        return put(FIELD_NAMES, Arrays.asList(fieldNames));
    }

    public GetRequestMap withSearchFieldNames(KeywordBidSearchFieldEnum... fieldNames) {
        return put(SEARCH_FIELD_NAMES, Arrays.asList(fieldNames));
    }

    public GetRequestMap withNetworkFieldNames(KeywordBidNetworkFieldEnum... fieldNames) {
        return put(NETWORK_FIELD_NAMES, Arrays.asList(fieldNames));
    }
}
