package ru.yandex.autotests.directapi.model.api5.keywordbids;


import com.yandex.direct.api.v5.keywordbids.KeywordBidActionResult;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ExceptionNotificationMap;

import static ch.lambdaj.Lambda.convert;

public class KeywordBidActionResultMap extends ModelBeanMap<KeywordBidActionResultMap> {

    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String WARNINGS = "warnings";
    public static final String ERRORS = "errors";

    public KeywordBidActionResultMap() {
        super();
        setBean(new KeywordBidActionResult());
    }

    public KeywordBidActionResultMap(KeywordBidActionResult actionResult) {
        super();
        setBean(actionResult);
    }

    public KeywordBidActionResultMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordBidActionResultMap withKeywordId(Long id) {
        this.put(KEYWORD_ID, id);
        return this;
    }

    public KeywordBidActionResultMap withAdGroupId(Long id) {
        this.put(AD_GROUP_ID, id);
        return this;
    }

    public KeywordBidActionResultMap withCampaignId(Long id) {
        this.put(CAMPAIGN_ID, id);
        return this;
    }

    public KeywordBidActionResultMap withWarnings(ExceptionNotificationMap... warnings) {
        this.put(WARNINGS, (warnings == null) ? null : convert(warnings, new BeanMapToBeanConverter()));
        return this;
    }

    public KeywordBidActionResultMap withErrors(ExceptionNotificationMap... errors) {
        this.put(ERRORS, (errors == null) ? null : convert(errors, new BeanMapToBeanConverter()));
        return this;
    }
}
