package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidGetItem;
import com.yandex.direct.api.v5.keywordbids.Network;
import com.yandex.direct.api.v5.keywordbids.ObjectFactory;
import com.yandex.direct.api.v5.keywordbids.Search;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class KeywordBidsGetItemMap extends ModelBeanMap<KeywordBidsGetItemMap> {
    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String SERVING_STATUS = "servingStatus";
    public static final String NETWORK = "network";
    public static final String SEARCH = "search";

    public static final String SEARCH_BID = "searchBid";
    public static final String NETWORK_BID = "networkBid";

    public KeywordBidsGetItemMap() {
        super();
        setBean(new KeywordBidGetItem());
    }

    public KeywordBidsGetItemMap withKeywordId(Long keywordId) {
        return put(KEYWORD_ID, keywordId);
    }

    public KeywordBidsGetItemMap withAdGroupId(Long adGroupId) {
        return put(AD_GROUP_ID, adGroupId);
    }

    public KeywordBidsGetItemMap withCampaignId(Long campaignId) {
        return put(CAMPAIGN_ID, campaignId);
    }

    public KeywordBidsGetItemMap withStrategyPriority(PriorityEnum priority) {
        return put(STRATEGY_PRIORITY, new ObjectFactory().createKeywordBidGetItemStrategyPriority(priority));
    }

    public KeywordBidsGetItemMap withServingStatus(ServingStatusEnum servingStatus) {
        return put(SERVING_STATUS, servingStatus);
    }

    public KeywordBidsGetItemMap withSearchBid(Long bid) {
        Search search = new Search();
        search.setBid(bid);
        return put(SEARCH, search);
    }

    public KeywordBidsGetItemMap withNetworkBid(Long contextBid) {
        Network network = new Network();
        network.setBid(contextBid);
        return put(NETWORK, network);
    }
}
