package ru.yandex.autotests.directapi.model.api5.keywordbids;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidsSelectionCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class KeywordBidsSelectionCriteriaMap extends ModelBeanMap<KeywordBidsSelectionCriteriaMap> {

    public static final String KEYWORDS_IDS = "keywordIds";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String SERVING_STATUSES = "servingStatuses";

    public KeywordBidsSelectionCriteriaMap() {
        super();
        setBean(new KeywordBidsSelectionCriteria());
    }

    public KeywordBidsSelectionCriteriaMap(KeywordBidsSelectionCriteria keywordBidsSelectionCriteria) {
        super();
        setBean(keywordBidsSelectionCriteria);
    }

    public KeywordBidsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordBidsSelectionCriteriaMap withKeywordIds(Long... keywordsIds) {
        this.put(KEYWORDS_IDS, Arrays.asList(keywordsIds));
        return this;
    }

    public KeywordBidsSelectionCriteriaMap withCampaignIds(Long... camapignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(camapignIds));
        return this;
    }

    public KeywordBidsSelectionCriteriaMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public KeywordBidsSelectionCriteriaMap withServingStatuses(ServingStatusEnum... servingStatuses) {
        this.put(SERVING_STATUSES, Arrays.asList(servingStatuses));
        return this;
    }


}
