package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.keywordbids.KeywordBidSetAutoItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class KeywordBidsSetAutoItemMap extends ModelBeanMap<KeywordBidsSetAutoItemMap> {
    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String BIDDING_RULE = "biddingRule";

    public KeywordBidsSetAutoItemMap() {
        super();
        setBean(new KeywordBidSetAutoItem());
    }

    public KeywordBidsSetAutoItemMap(KeywordBidSetAutoItem bids) {
        super();
        setBean(bids);
    }

    public KeywordBidsSetAutoItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordBidsSetAutoItemMap withKeywordId(Long keywordsIds) {
        this.put(KEYWORD_ID, keywordsIds);
        return this;
    }

    public KeywordBidsSetAutoItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public KeywordBidsSetAutoItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public KeywordBidsSetAutoItemMap withBiddingRule(SetAutoBiddingRule rule) {
        this.put(BIDDING_RULE, rule.getBean());
        return this;
    }

}
