package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSetItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class KeywordBidsSetItemMap extends ModelBeanMap<KeywordBidsSetItemMap> {
    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String SEARCH_BID = "searchBid";
    public static final String NETWORK_BID = "networkBid";

    public KeywordBidsSetItemMap() {
        super();
        setBean(new KeywordBidSetItem());
    }

    public KeywordBidsSetItemMap(KeywordBidSetItem bids) {
        super();
        setBean(bids);
    }

    public KeywordBidsSetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordBidsSetItemMap withKeywordId(Long keywordsIds) {
        this.put(KEYWORD_ID, keywordsIds);
        return this;
    }

    public KeywordBidsSetItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public KeywordBidsSetItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public KeywordBidsSetItemMap withSearchBid(Long searchBid) {
        this.put(SEARCH_BID, searchBid);
        return this;
    }

    public KeywordBidsSetItemMap withNetworkBid(Long networkBid) {
        this.put(NETWORK_BID, networkBid);
        return this;
    }

    public KeywordBidsSetItemMap withStrategyPriority(PriorityEnum strategyPriority) {
        this.put(STRATEGY_PRIORITY, strategyPriority);
        return this;
    }
}
