package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.keywordbids.NetworkByCoverage;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class NetworkByCoverageBiddingRule extends ModelBeanMap<NetworkByCoverageBiddingRule> {
    public static final String TARGET_COVERAGE = "targetCoverage";
    public static final String INCREASE_PERCENT = "increasePercent";
    public static final String BID_CEILING = "bidCeiling";

    public NetworkByCoverageBiddingRule() {
        super();
        setBean(new NetworkByCoverage());
    }

    public NetworkByCoverageBiddingRule withIncreasePercent(Integer increasePercent) {
        this.put(INCREASE_PERCENT, increasePercent);
        return this;
    }

    public NetworkByCoverageBiddingRule withTargetCoverage(Integer targetCoverage) {
        this.put(TARGET_COVERAGE, targetCoverage);
        return this;
    }

    public NetworkByCoverageBiddingRule withBidCeiling(Long bidCeiling) {
        this.put(BID_CEILING, bidCeiling);
        return this;
    }
}
