package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.keywordbids.SearchByTrafficVolume;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SearchByTrafficVolumeBiddingRule extends ModelBeanMap<SearchByTrafficVolumeBiddingRule> {
    public static final String TARGET_TRAFFIC_VOLUME = "targetTrafficVolume";
    public static final String INCREASE_PERCENT = "increasePercent";
    public static final String BID_CEILING = "bidCeiling";

    public SearchByTrafficVolumeBiddingRule() {
        super();
        setBean(new SearchByTrafficVolume());
    }

    public SearchByTrafficVolumeBiddingRule withIncreasePercent(Integer increasePercent) {
        this.put(INCREASE_PERCENT, increasePercent);
        return this;
    }

    public SearchByTrafficVolumeBiddingRule withTargetTrafficVolume(Integer targetTrafficVolume) {
        this.put(TARGET_TRAFFIC_VOLUME, targetTrafficVolume);
        return this;
    }

    public SearchByTrafficVolumeBiddingRule withBidCeiling(Long bidCeiling) {
        this.put(BID_CEILING, bidCeiling);
        return this;
    }
}
