package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.keywordbids.BiddingRule;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SetAutoBiddingRule extends ModelBeanMap<SetAutoBiddingRule> {
    public static final String NETWORK_BY_COVERAGE = "networkByCoverage";
    public static final String SEARCH_BY_TRAFFIC_VOLUME = "searchByTrafficVolume";

    public SetAutoBiddingRule() {
        super();
        setBean(new BiddingRule());
    }

    public SetAutoBiddingRule withNetworkByCoverage(NetworkByCoverageBiddingRule rule) {
        this.put(NETWORK_BY_COVERAGE, rule.getBean());
        return this;
    }

    public SetAutoBiddingRule withSearchByTrafficVolume(SearchByTrafficVolumeBiddingRule rule) {
        this.put(SEARCH_BY_TRAFFIC_VOLUME, rule.getBean());
        return this;
    }
}
