package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.keywordbids.SetAutoRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class SetAutoRequestMap extends ModelBeanMap<SetAutoRequestMap> {

    public static final String KEYWORD_BIDS = "keywordBids";

    public SetAutoRequestMap() {
        super();
        setBean(new SetAutoRequest());
    }

    public SetAutoRequestMap(SetAutoRequest setRequest) {
        super();
        setBean(setRequest);
    }

    public SetAutoRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SetAutoRequestMap withKeywordBids(KeywordBidsSetAutoItemMap... bids) {
        this.put(KEYWORD_BIDS, (bids == null) ? null : convert(bids, new BeanMapToBeanConverter()));
        return this;
    }
}
