package ru.yandex.autotests.directapi.model.api5.keywordbids;

import com.yandex.direct.api.v5.keywordbids.SetRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class SetRequestMap extends ModelBeanMap<SetRequestMap> {

    public static final String KEYWORD_BIDS = "keywordBids";

    public SetRequestMap() {
        super();
        setBean(new SetRequest());
    }

    public SetRequestMap(SetRequest setRequest) {
        super();
        setBean(setRequest);
    }

    public SetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SetRequestMap withKeywordBids(KeywordBidsSetItemMap... bids) {
        this.put(KEYWORD_BIDS, (bids == null) ? null : convert(bids, new BeanMapToBeanConverter()));
        return this;
    }
}
