package ru.yandex.autotests.directapi.model.api5.keywords;

import com.yandex.direct.api.v5.keywords.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;


/**
 * Created by chicos on 20.11.14.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String KEYWORDS = "keywords";

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withKeywords(KeywordAddMap... keywords) {
        this.put(KEYWORDS, (keywords == null) ? null : convert(keywords, new BeanMapToBeanConverter()));
        return this;
    }
}
