package ru.yandex.autotests.directapi.model.api5.keywords;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywords.KeywordAddItem;

import ru.yandex.autotests.direct.utils.PhraseTexts;
import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.AutotargetingCategoryMap;

import static ch.lambdaj.Lambda.convert;


/**
 * Created by chicos on 20.11.14.
 */
public class KeywordAddMap extends ModelBeanMap<KeywordAddMap> {

    public static final String KEYWORD = "keyword";
    public static final String ADGROUP_ID = "adGroupId";
    public static final String USER_PARAM_1 = "userParam1";
    public static final String USER_PARAM_2 = "userParam2";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";
    public static final String AUTOTARGETING_CATEGORIES = "autotargetingCategories";

    public static final String AUTOTARGETING_KEYWORD = "---autotargeting";

    public static final int MAX_USER_PARAM_LENGTH = 255;

    private static PhraseTexts phrases = new PhraseTexts();

    public KeywordAddMap() {
        super();
        setBean(new KeywordAddItem());
    }

    public KeywordAddMap(KeywordAddItem keyword) {
        super();
        setBean(keyword);
    }

    public KeywordAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordAddMap shortKeyword() {
        this.clear();
        this.withKeyword(phrases.getNext());
        return this;
    }

    public KeywordAddMap defaultKeyword() {
        this.clear();
        return this.withKeyword(phrases.getNext())
                .withUserParam1("123456")
                .withUserParam2("superParam");
    }

    public KeywordAddMap defaultKeywordWithAutotargetingPrefix() {
        this.clear();
        return this.withKeyword(AUTOTARGETING_KEYWORD + " " + phrases.getNext())
                .withUserParam1("123456")
                .withUserParam2("superParam");
    }

    public KeywordAddMap shortAutotargeting(Long adGroupId) {
        this.clear();
        return this.withAdGroupId(adGroupId).withKeyword(AUTOTARGETING_KEYWORD);
    }

    public KeywordAddMap autotargeting(Long adGroupId) {
        return shortAutotargeting(adGroupId)
                .withUserParam1("123456")
                .withUserParam2("superParam");
    }

    public KeywordAddMap withKeyword(String keyword) {
        this.put(KEYWORD, keyword);
        return this;
    }

    public KeywordAddMap withAdGroupId(long adGroupId) {
        this.put(ADGROUP_ID, adGroupId);
        return this;
    }

    public KeywordAddMap withUserParam1(String param1) {
        this.put(USER_PARAM_1, param1);
        return this;
    }

    public KeywordAddMap withUserParam2(String param2) {
        this.put(USER_PARAM_2, param2);
        return this;
    }

    public KeywordAddMap withStrategyPriority(PriorityEnum strategyPriority) {
        this.put(STRATEGY_PRIORITY, strategyPriority);
        return this;
    }

    public KeywordAddMap withBid(Long bid) {
        this.put(BID, bid);
        return this;
    }

    public KeywordAddMap withContextBid(Long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return this;
    }

    public KeywordAddMap withAutotargetingCategories(AutotargetingCategoryMap... categories) {
        this.put(AUTOTARGETING_CATEGORIES,
                (categories == null) ? null : convert(categories, new BeanMapToBeanConverter()));
        return this;
    }
}
