package ru.yandex.autotests.directapi.model.api5.keywords;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.general.AutotargetingCategoryArray;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.keywords.KeywordFieldEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import com.yandex.direct.api.v5.keywords.KeywordProductivity;
import com.yandex.direct.api.v5.keywords.ObjectFactory;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.AutotargetingCategoryArrayMap;
import ru.yandex.autotests.directapi.model.api5.general.AutotargetingCategoryMap;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;


/**
 * Created by chicos on 20.11.14.
 */
public class KeywordGetItemMap extends ModelBeanMap<KeywordGetItemMap> {

    public static final String ID = "id";
    public static final String KEYWORD = "keyword";
    public static final String ADGROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String USER_PARAM_1 = "userParam1";
    public static final String USER_PARAM_2 = "userParam2";
    public static final String PRODUCTIVITY = "productivity";
    public static final String STATE = "state";
    public static final String STATUS = "status";
    public static final String STATISTICS_NETWORK = "statisticsNetwork";
    public static final String STATISTICS_SEARCH = "statisticsSearch";
    public static final String SERVING_STATUS = "servingStatus";
    public static final String AUTOTARGETING_CATEGORIES = "autotargetingCategories";

    public KeywordGetItemMap() {
        super();
        setBean(new KeywordGetItem());
    }

    public KeywordGetItemMap(KeywordGetItem keyword) {
        super();
        setBean(keyword);
    }

    public KeywordGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordGetItemMap withId(long id) {
        this.put(ID, id);
        return this;
    }

    public KeywordGetItemMap withKeyword(String keyword) {
        this.put(KEYWORD, keyword);
        return this;
    }

    public KeywordGetItemMap withCampaignId(long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public KeywordGetItemMap withAdGroupId(long adGroupId) {
        this.put(ADGROUP_ID, adGroupId);
        return this;
    }

    public KeywordGetItemMap withBid(long bid) {
        this.put(BID, bid);
        return this;
    }

    public KeywordGetItemMap withContextBid(long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return this;
    }

    public KeywordGetItemMap withStrategyPriority(PriorityEnum priority) {
        JAXBElement<PriorityEnum> jaxbElement = new ObjectFactory().createKeywordGetItemStrategyPriority(priority);
        this.put(STRATEGY_PRIORITY, jaxbElement);
        return this;
    }

    public KeywordGetItemMap withUserParam1(String param1) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createKeywordGetItemUserParam1(param1);
        this.put(USER_PARAM_1, jaxbElement);
        return this;
    }

    public KeywordGetItemMap withUserParam2(String param2) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createKeywordGetItemUserParam1(param2);
        this.put(USER_PARAM_2, jaxbElement);
        return this;
    }

    public KeywordGetItemMap withProductivity(ProductivityMap productivityMap) {
        KeywordProductivity productivityBean =
                (KeywordProductivity) ((productivityMap == null) ? null : productivityMap.getBean());
        JAXBElement<KeywordProductivity> jaxbProd =
                new ObjectFactory().createKeywordGetItemProductivity(productivityBean);
        this.put(PRODUCTIVITY, jaxbProd);
        return this;
    }

    public KeywordGetItemMap withState(StateEnum state) {
        this.put(STATE, state);
        return this;
    }

    public KeywordGetItemMap withStatus(StatusEnum status) {
        this.put(STATUS, status);
        return this;
    }

    public KeywordGetItemMap withServingStatus(ServingStatusEnum servingStatus) {
        this.put(SERVING_STATUS, servingStatus);
        return this;
    }

    public KeywordGetItemMap withStatisticsNetwork(StatisticsMap statisticsNetwork) {
        this.put(STATISTICS_NETWORK, statisticsNetwork != null ? statisticsNetwork.getBean() : null);
        return this;
    }

    public KeywordGetItemMap withStatisticsSearch(StatisticsMap statisticsSearch) {
        this.put(STATISTICS_SEARCH, statisticsSearch != null ? statisticsSearch.getBean() : null);
        return this;
    }

    public KeywordGetItemMap withAutotargetingCategories(AutotargetingCategoryArrayMap autotargetingCategoryArrayMap) {
        AutotargetingCategoryArray autotargetingCategoryArray = (AutotargetingCategoryArray)
                ((autotargetingCategoryArrayMap == null) ? null
                        : autotargetingCategoryArrayMap.getBean());
        JAXBElement<AutotargetingCategoryArray> jaxbElement =
                new ObjectFactory().createKeywordGetItemAutotargetingCategories(autotargetingCategoryArray);
        return this.put(AUTOTARGETING_CATEGORIES, jaxbElement);
    }

    public KeywordGetItemMap withAutotargetingCategories(AutotargetingCategoryMap... autotargetingCategories) {
        AutotargetingCategoryArrayMap autotargetingCategoryArray =
                (autotargetingCategories == null) ? null :
                        new AutotargetingCategoryArrayMap().withItems(autotargetingCategories);
        return this.withAutotargetingCategories(autotargetingCategoryArray);
    }

    public static String[] shortFieldsSet() {
        return new String[]{ID, ADGROUP_ID, KEYWORD, USER_PARAM_1, USER_PARAM_2};
    }

    public static String getKeywordFieldsAsString() {
        StringBuilder builder = new StringBuilder();
        for (KeywordFieldEnum field : KeywordFieldEnum.values()) {
            builder.append(field.value()).append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    public static Set<String> getAvailableStates() {
        Set availableStates = new HashSet<>();
        availableStates.addAll(Arrays.asList(
                BidsStatusmoderate.New,
                BidsStatusmoderate.Yes,
                BidsStatusmoderate.No));
        return availableStates;
    }
}
