package ru.yandex.autotests.directapi.model.api5.keywords;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.keywords.KeywordUpdateItem;
import com.yandex.direct.api.v5.keywords.ObjectFactory;

import ru.yandex.autotests.direct.utils.PhraseTexts;
import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.AutotargetingCategoryMap;

import static ch.lambdaj.Lambda.convert;


/**
 * Created by chicos on 05.02.15.
 */
public class KeywordUpdateMap extends ModelBeanMap<KeywordUpdateMap> {

    public static final String ID = "id";
    public static final String KEYWORD = "keyword";
    public static final String USER_PARAM_1 = "userParam1";
    public static final String USER_PARAM_2 = "userParam2";
    public static final String AUTOTARGETING_CATEGORIES = "autotargetingCategories";

    public KeywordUpdateMap() {
        super();
        setBean(new KeywordUpdateItem());
    }

    public KeywordUpdateMap(KeywordUpdateItem keyword) {
        super();
        setBean(keyword);
    }

    public KeywordUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordUpdateMap withKeyword(String keyword) {
        this.put(KEYWORD, keyword);
        return this;
    }

    public KeywordUpdateMap withId(long keywordId) {
        this.put(ID, keywordId);
        return this;
    }

    public KeywordUpdateMap withUserParam1(String param1) {
        JAXBElement<String> jaxbParam1 = new ObjectFactory().createKeywordUpdateItemUserParam1(param1);
        this.put(USER_PARAM_1, jaxbParam1);
        return this;
    }

    public KeywordUpdateMap withUserParam2(String param2) {
        JAXBElement<String> jaxbParam2 = new ObjectFactory().createKeywordUpdateItemUserParam2(param2);
        this.put(USER_PARAM_2, jaxbParam2);
        return this;
    }

    public KeywordUpdateMap defaultKeyword() {
        this.clear();
        return this.withKeyword(PhraseTexts.getRandom());
    }

    public KeywordUpdateMap withAutotargetingCategories(AutotargetingCategoryMap... categories) {
        this.put(AUTOTARGETING_CATEGORIES,
                (categories == null) ? null : convert(categories, new BeanMapToBeanConverter()));
        return this;
    }
}
