package ru.yandex.autotests.directapi.model.api5.keywords;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.keywords.KeywordStateSelectionEnum;
import com.yandex.direct.api.v5.keywords.KeywordStatusSelectionEnum;
import com.yandex.direct.api.v5.keywords.KeywordsSelectionCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by chicos on 20.11.14.
 */
public class KeywordsSelectionCriteriaMap extends ModelBeanMap<KeywordsSelectionCriteriaMap> {

    public static final String IDS = "ids";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String STATES = "states";
    public static final String STATUSES = "statuses";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String MODIFIED_SINCE = "modifiedSince";
    public static final String SERVING_STATUSES = "servingStatuses";

    public static final int IDS_MAX_LENGTH = 10000;
    public static final int ADGROUP_IDS_MAX_LENGTH = 1000;
    public static final int CAMPAIGN_IDS__MAX_LENGTH = 10;

    public KeywordsSelectionCriteriaMap() {
        super();
        setBean(new KeywordsSelectionCriteria());
    }

    public KeywordsSelectionCriteriaMap(KeywordsSelectionCriteria keywordsSelectionCriteria) {
        super();
        setBean(keywordsSelectionCriteria);
    }

    public KeywordsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public KeywordsSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, (ids == null) ? null : Arrays.asList(ids));
        return this;
    }

    public KeywordsSelectionCriteriaMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, (campaignIds == null) ? null : Arrays.asList(campaignIds));
        return this;
    }

    public KeywordsSelectionCriteriaMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, (adGroupIds == null) ? null : Arrays.asList(adGroupIds));
        return this;
    }

    /**
     * ON, SUSPENDED available
     */
    public KeywordsSelectionCriteriaMap withStates(KeywordStateSelectionEnum... states) {
        this.put(STATES, (states == null) ? null : Arrays.asList(states));
        return this;
    }

    /**
     * DRAFT, ACCEPTED, REJECTED available
     */
    public KeywordsSelectionCriteriaMap withStatuses(KeywordStatusSelectionEnum... statuses) {
        this.put(STATUSES, (statuses == null) ? null : Arrays.asList(statuses));
        return this;
    }

    /**
     * Used for negative test to pass invalid values
     *
     * @param states
     * @return
     */
    public KeywordsSelectionCriteriaMap withStates(String... states) {
        this.put(STATES, (states == null) ? null : Arrays.asList(states));
        return this;
    }

    /**
     * Used for negative test to pass invalid values
     *
     * @param statuses
     * @return
     */
    public KeywordsSelectionCriteriaMap withStatuses(String... statuses) {
        this.put(STATUSES, (statuses == null) ? null : Arrays.asList(statuses));
        return this;
    }

    public KeywordsSelectionCriteriaMap withServingStatuses(ServingStatusEnum... servingStatuses) {
        this.put(SERVING_STATUSES, Arrays.asList(servingStatuses));
        return this;
    }

    public KeywordsSelectionCriteriaMap withModifiedSince(String modifiedSince) {
        this.put(MODIFIED_SINCE, modifiedSince);
        return this;
    }

    public static String getAvailableStatusesAsString() {
        String statusesAsString = Arrays.asList(StatusEnum.DRAFT, StatusEnum.ACCEPTED, StatusEnum.REJECTED).toString();
        return statusesAsString.substring(1, statusesAsString.length() - 1);
    }

    public static String getAvailableStatesAsString() {
        String statesAsString = Arrays.asList(StateEnum.OFF, StateEnum.ON, StateEnum.SUSPENDED).toString();
        return statesAsString.substring(1, statesAsString.length() - 1);
    }
}
