package ru.yandex.autotests.directapi.model.api5.keywords;

import java.math.BigDecimal;
import java.util.Arrays;

import com.yandex.direct.api.v5.keywords.KeywordProductivity;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by chicos on 20.11.14.
 */
public class ProductivityMap extends ModelBeanMap<ProductivityMap> {

    public static final String VALUE = "value";
    public static final String REFERENCES = "references";

    public ProductivityMap() {
        super();
        setBean(new KeywordProductivity());
    }

    public ProductivityMap(KeywordProductivity addRequest) {
        super();
        setBean(addRequest);
    }

    public ProductivityMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ProductivityMap withValue(double value) {
        return this.withValue(new BigDecimal(value));
    }

    public ProductivityMap withValue(BigDecimal value) {
        return this.withValue(value, 1);
    }

    public ProductivityMap withValue(BigDecimal value, int scale) {
        this.put(VALUE, value.setScale(scale, BigDecimal.ROUND_HALF_UP));
        return this;
    }

    public ProductivityMap withReferences(Integer... references) {
        this.put(REFERENCES, Arrays.asList(references));
        return this;
    }
}
