package ru.yandex.autotests.directapi.model.api5.keywords;

import com.yandex.direct.api.v5.keywords.ResumeRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by chicos on 06.02.15.
 */
public class ResumeRequestMap extends ModelBeanMap<ResumeRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public ResumeRequestMap() {
        super();
        setBean(new ResumeRequest());
    }

    public ResumeRequestMap(ResumeRequest suspendRequest) {
        super();
        setBean(suspendRequest);
    }

    public ResumeRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ResumeRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
