package ru.yandex.autotests.directapi.model.api5.keywords;

import com.yandex.direct.api.v5.keywords.UpdateRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;


/**
 * Created by chicos on 06.02.15.
 */
public class UpdateRequestMap extends ModelBeanMap<UpdateRequestMap> {

    public static final String KEYWORDS = "keywords";

    public UpdateRequestMap() {
        super();
        setBean(new UpdateRequest());
    }

    public UpdateRequestMap(UpdateRequest updateRequest) {
        super();
        setBean(updateRequest);
    }

    public UpdateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public UpdateRequestMap withKeywords(KeywordUpdateMap... keywords) {
        this.put(KEYWORDS, (keywords == null) ? null : convert(keywords, new BeanMapToBeanConverter()));
        return this;
    }
}
