package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateRequestItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

@ParametersAreNonnullByDefault
public class DeduplicateRequestItemMap extends ModelBeanMap<DeduplicateRequestItemMap> {

    public static final String ID = "id";
    public static final String KEYWORD = "keyword";
    public static final String WEIGHT = "weight";

    public DeduplicateRequestItemMap() {
        super();
        setBean(new DeduplicateRequestItem());
    }

    public DeduplicateRequestItemMap(DeduplicateRequestItem request) {
        super();
        setBean(request);
    }

    @Override
    public DeduplicateRequestItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DeduplicateRequestItemMap withKeyword(String keyword) {
        return put(KEYWORD, keyword);
    }

    public DeduplicateRequestItemMap withId(Long id) {
        return put(ID, id);
    }

    public DeduplicateRequestItemMap withWeight(Long weight) {
        return put(WEIGHT, weight);
    }
}
