package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import java.util.List;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateOperationEnum;
import com.yandex.direct.api.v5.keywordsresearch.DeduplicateRequest;
import one.util.streamex.StreamEx;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static java.util.stream.Collectors.toList;

public class DeduplicateRequestMap extends ModelBeanMap<DeduplicateRequestMap> {

    public static final String KEYWORDS = "keywords";
    public static final String OPERATION = "operation";

    public DeduplicateRequestMap() {
        super();
        setBean(new DeduplicateRequest());
    }

    public DeduplicateRequestMap(DeduplicateRequest request) {
        super();
        setBean(request);
    }

    @Override
    public DeduplicateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DeduplicateRequestMap withKeywords(List<DeduplicateRequestItemMap> keywords) {
        return this.put(KEYWORDS, keywords.stream().map(BeanMap::getBean).collect(toList()));
    }

    public DeduplicateRequestMap withKeywords(DeduplicateRequestItemMap... keywords) {
        return this.put(KEYWORDS, Stream.of(keywords).map(BeanMap::getBean).collect(toList()));
    }

    public DeduplicateRequestMap withOperations(DeduplicateOperationEnum... operations) {
        return this.put(OPERATION, StreamEx.of(operations).toList());
    }

    public DeduplicateRequestMap withOperations(List<DeduplicateOperationEnum> operations) {
        return this.put(OPERATION, operations);
    }
}
