package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import java.util.List;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static java.util.stream.Collectors.toList;

public class HasSearchVolumeRequestMap extends ModelBeanMap<HasSearchVolumeRequestMap> {
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";

    public HasSearchVolumeRequestMap() {
        super();
        setBean(new HasSearchVolumeRequest());
    }

    public HasSearchVolumeRequestMap(HasSearchVolumeRequest request) {
        super();
        setBean(request);
    }

    @Override
    public HasSearchVolumeRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public HasSearchVolumeRequestMap withSelectionCriteria(HasSearchVolumeSelectionCriteriaMap selectionCriteria) {
        super.put(SELECTION_CRITERIA, selectionCriteria.getBean());
        return this;
    }

    public HasSearchVolumeRequestMap withFieldNames(HasSearchVolumeFieldEnum... fieldNames) {
        super.put(FIELD_NAMES, Stream.of(fieldNames).collect(toList()));
        return this;
    }

    public HasSearchVolumeRequestMap withFieldNames(List<HasSearchVolumeFieldEnum> fieldNames) {
        super.put(FIELD_NAMES, fieldNames);
        return this;
    }
}
