package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import java.util.List;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeSelectionCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static java.util.stream.Collectors.toList;

public class HasSearchVolumeSelectionCriteriaMap extends ModelBeanMap<HasSearchVolumeSelectionCriteriaMap> {
    public static final String KEYWORDS = "keywords";
    public static final String REGION_IDS = "regionIds";

    public HasSearchVolumeSelectionCriteriaMap() {
        super();
        setBean(new HasSearchVolumeSelectionCriteria());
    }

    public HasSearchVolumeSelectionCriteriaMap(HasSearchVolumeSelectionCriteria request) {
        super();
        setBean(request);
    }

    @Override
    public HasSearchVolumeSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public HasSearchVolumeSelectionCriteriaMap withKeywords(String... keywords) {
        super.put(KEYWORDS, Stream.of(keywords).collect(toList()));
        return this;
    }

    public HasSearchVolumeSelectionCriteriaMap withKeywords(List<String> keywords) {
        super.put(KEYWORDS, keywords);
        return this;
    }

    public HasSearchVolumeSelectionCriteriaMap withRegionIds(Long... regionIds) {
        super.put(REGION_IDS, Stream.of(regionIds).collect(toList()));
        return this;
    }

    public HasSearchVolumeSelectionCriteriaMap withRegionIds(List<Long> regionIds) {
        super.put(REGION_IDS, regionIds);
        return this;
    }
}
