package ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets;

import com.yandex.direct.api.v5.negativekeywordsharedsets.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class AddRequestMap extends ModelBeanMap<AddRequestMap> {
    public static final String NEGATIVE_KEYWORD_SHARED_SETS = "negativeKeywordSharedSets";

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withNegativeKeywordSharedSets(
            NegativeKeywordSharedSetAddItemMap... negativeKeywordSharedSetAddItems)
    {
        this.put(NEGATIVE_KEYWORD_SHARED_SETS,
                (negativeKeywordSharedSetAddItems == null) ? null
                        : convert(negativeKeywordSharedSetAddItems, new BeanMapToBeanConverter()));
        return this;
    }
}
