package ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets;

import java.util.Arrays;

import com.yandex.direct.api.v5.negativekeywordsharedsets.GetRequest;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(NegativeKeywordSharedSetFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }
}
