package ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets;

import java.util.List;

import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetAddItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class NegativeKeywordSharedSetAddItemMap extends ModelBeanMap<NegativeKeywordSharedSetAddItemMap> {
    public static final String NAME = "name";
    public static final String NEGATIVE_KEYWORDS = "negativeKeywords";

    public NegativeKeywordSharedSetAddItemMap() {
        super();
        setBean(new NegativeKeywordSharedSetAddItem());
    }

    @Override
    public NegativeKeywordSharedSetAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public NegativeKeywordSharedSetAddItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public NegativeKeywordSharedSetAddItemMap withNegativeKeywords(List<String> negativeKeywords) {
        this.put(NEGATIVE_KEYWORDS, negativeKeywords);
        return this;
    }
}
