package ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets;

import com.yandex.direct.api.v5.negativekeywordsharedsets.UpdateRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class UpdateRequestMap extends ModelBeanMap<UpdateRequestMap> {
    public static final String NEGATIVE_KEYWORD_SHARED_SETS = "negativeKeywordSharedSets";

    public UpdateRequestMap() {
        super();
        setBean(new UpdateRequest());
    }

    public UpdateRequestMap(UpdateRequest updateRequest) {
        super();
        setBean(updateRequest);
    }

    public UpdateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public UpdateRequestMap withNegativeKeywordSharedSets(
            NegativeKeywordSharedSetUpdateItemMap... negativeKeywordSharedSetUpdateItems)
    {
        this.put(NEGATIVE_KEYWORD_SHARED_SETS, (negativeKeywordSharedSetUpdateItems == null) ? null
                : convert(negativeKeywordSharedSetUpdateItems, new BeanMapToBeanConverter()));
        return this;
    }
}
