package ru.yandex.autotests.directapi.model.api5.reports;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FilterItem;
import com.yandex.direct.api.v5.reports.FilterOperatorEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 31.05.16.
 */
public class FilterItemMap extends ModelBeanMap<FilterItemMap> {

    public static final String FIELD = "field";
    public static final String OPERATOR = "operator";
    public static final String VALUES = "values";

    public FilterItemMap() {
        super();
        setBean(new FilterItem());
    }

    public FilterItemMap(FilterItem filterItem) {
        super();
        setBean(filterItem);
    }

    public FilterItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public FilterItemMap withField(FieldEnum field) {
        this.put(FIELD, field);
        return this;
    }

    public FilterItemMap withOperator(FilterOperatorEnum operator) {
        this.put(OPERATOR, operator);
        return this;
    }

    public FilterItemMap withValues(String... values) {
        this.put(VALUES, (values == null) ? null : Arrays.asList(values));
        return this;
    }

    public FilterItemMap withValues(Number... values) {
        this.put(VALUES, (values == null) ? null : Stream.of(values).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }
}
