package ru.yandex.autotests.directapi.model.api5.reports;

import com.yandex.direct.api.v5.general.SortOrderEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.OrderBy;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 31.05.16.
 */
public class OrderByMap extends ModelBeanMap<OrderByMap> {

    public static final String FIELD = "field";
    public static final String SORT_ORDER = "sortOrder";

    public OrderByMap() {
        super();
        setBean(new OrderBy());
    }

    public OrderByMap(OrderBy orderBy) {
        super();
        setBean(orderBy);
    }

    public OrderByMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public OrderByMap withField(FieldEnum field) {
        this.put(FIELD, field);
        return this;
    }

    public OrderByMap withSortOrder(SortOrderEnum sortOrder) {
        this.put(SORT_ORDER, sortOrder);
        return this;
    }
}
