package ru.yandex.autotests.directapi.model.api5.reports;

import com.yandex.direct.api.v5.reports.Page;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 31.05.16.
 */
public class PageMap extends ModelBeanMap<PageMap> {

    public static final String LIMIT = "limit";

    public PageMap() {
        super();
        setBean(new Page());
    }

    public PageMap(Page page) {
        super();
        setBean(page);
    }

    public PageMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PageMap withLimit(Long limit) {
        this.put(LIMIT, limit);
        return this;
    }
}
