package ru.yandex.autotests.directapi.model.api5.reports;

import java.util.List;
import java.util.Map;

import com.yandex.direct.api.v5.reports.FieldEnum;

/**
 * Created by gerdler on 23.12.16.
 */
public class ReportResponse {

    private String content;
    private Map<String, String> headers;
    private ReportProcessingMode actualProcessingMode;

    public ReportResponse(ReportProcessingMode actualProcessingMode, String content, Map<String, String> headers) {
        this.actualProcessingMode = actualProcessingMode;
        this.content = content;
        this.headers = headers;
    }

    public String getContent() {
        return content;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ReportProcessingMode getActualProcessingMode() {
        return actualProcessingMode;
    }

    public void setActualProcessingMode(ReportProcessingMode actualProcessingMode) {
        this.actualProcessingMode = actualProcessingMode;
    }

    public ReportsData getReportsData(List<FieldEnum> fieldNames) {
        return new ReportsData(content, fieldNames);
    }

}
