package ru.yandex.autotests.directapi.model.api5.reports;

import com.yandex.direct.api.v5.reports.SelectionCriteria;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 31.05.16.
 */
public class SelectionCriteriaMap extends ModelBeanMap<SelectionCriteriaMap> {

    public static final String DATE_FROM = "dateFrom";
    public static final String DATE_TO = "dateTo";
    public static final String FILTER = "filter";

    public SelectionCriteriaMap() {
        super();
        setBean(new SelectionCriteria());
    }

    public SelectionCriteriaMap(SelectionCriteria selectionCriteria) {
        super();
        setBean(selectionCriteria);
    }

    public SelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SelectionCriteriaMap withDateFrom(String dateFrom) {
        this.put(DATE_FROM, dateFrom);
        return this;
    }

    public SelectionCriteriaMap withDateTo(String dateTo) {
        this.put(DATE_TO, dateTo);
        return this;
    }

    public SelectionCriteriaMap withFilter(FilterItemMap... filter) {
        this.put(FILTER, (filter == null) ? null : convert(filter, new BeanMapToBeanConverter()));
        return this;
    }

    public SelectionCriteriaMap withDefaultLimitedPeriod() {
        return this.withDateFrom("2019-08-01").withDateTo("2019-09-01");
    }
}
