package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import com.yandex.direct.api.v5.retargetinglists.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class AddRequestMap extends ModelBeanMap<AddRequestMap> {
    public static final String ADD_REQUEST = "AddRequest";
    public static final String RETARGETING_LISTS = "retargetingLists";
    public static final Integer MAX_AMOUNT_RETARGETING_LISTS = 2000;
    public static final Integer MAX_AMOUNT_RETARGETING_LISTS_IN_ONE_REQUEST = 1000;

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withRetargetingLists(RetargetingListAddItemMap... retargetingLists) {
        this.put(RETARGETING_LISTS,
                (retargetingLists == null) ? null : convert(retargetingLists, new BeanMapToBeanConverter()));
        return this;
    }

}
