package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import java.util.Arrays;

import com.yandex.direct.api.v5.retargetinglists.GetRequest;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final Integer MAX_AMOUNT_OF_IDS_IN_GET_REQUEST = 10000;

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(RetargetingListSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }


    public GetRequestMap withFieldNames(RetargetingListFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFullFieldNames() {
        this.put(FIELD_NAMES, Arrays.asList(
                RetargetingListFieldEnum.ID,
                RetargetingListFieldEnum.DESCRIPTION,
                RetargetingListFieldEnum.NAME,
                RetargetingListFieldEnum.IS_AVAILABLE,
                RetargetingListFieldEnum.SCOPE,
                RetargetingListFieldEnum.RULES
        ));
        return this;
    }
}
