package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListAddItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;
import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.irt.testutils.RandomUtils;

import static ch.lambdaj.Lambda.convert;

public class RetargetingListAddItemMap extends ModelBeanMap<RetargetingListAddItemMap> {

    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String RULES = "rules";
    public static final Integer MAX_LENGTH_OF_NAME = 250;
    public static final Integer MAX_LENGTH_OF_DESCRIPTION = 4096;
    public static final Integer MAX_AMOUNT_OF_RULES = 50;

    public RetargetingListAddItemMap() {
        super();
        setBean(new RetargetingListAddItem());
    }

    public RetargetingListAddItemMap(RetargetingListAddItem retargetingListAddItemAddItem) {
        super();
        setBean(retargetingListAddItemAddItem);
    }

    public RetargetingListAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RetargetingListAddItemMap withType(RetargetingListTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public RetargetingListAddItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public RetargetingListAddItemMap withDescription(String description) {
        this.put(DESCRIPTION, description);
        return this;
    }

    public RetargetingListAddItemMap withRandomName() {
        this.put(NAME, "Name " + RandomStringUtils.randomAlphanumeric(5));
        return this;
    }

    public RetargetingListAddItemMap withRandomDescription() {
        this.put(DESCRIPTION, "Description " + RandomStringUtils.randomAlphanumeric(5));
        return this;
    }

    public RetargetingListAddItemMap withRules(RetargetingListRuleItemMap... rules) {
        this.put(RULES, (rules == null) ? null : convert(rules, new BeanMapToBeanConverter()));
        return this;
    }

    public RetargetingListAddItemMap defaultRetargetingListAddItemMap(Long externalId) {
        return this
                .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                .withDescription("Description " + RandomStringUtils.randomAlphanumeric(5))
                .withRules(new RetargetingListRuleItemMap()
                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                .withMembershipLifeSpan(RandomUtils.getRandomInteger(1, 90))
                                .withExternalId(externalId)));
    }

    public RetargetingListAddItemMap defaultRetargetingListAddItemMap(
            RetargetingListRuleArgumentItemMap... retargetingListRuleArgumentItemMaps)
    {
        return this
                .withName("Name " + RandomStringUtils.randomAlphanumeric(5))
                .withDescription("Description" + RandomStringUtils.randomAlphanumeric(5))
                .withRules(new RetargetingListRuleItemMap()
                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                        .withArgumentItems(retargetingListRuleArgumentItemMaps));
    }
}
