package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.retargetinglists.ObjectFactory;
import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class RetargetingListBaseMap<T> extends ModelBeanMap<RetargetingListBaseMap> {

    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String RULES = "rules";

    public RetargetingListBaseMap() {
        super();
    }

    public T withName(String name) {
        this.put(NAME, name);
        return (T) this;
    }


    public T withDescription(String description) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createRetargetingListBaseDescription(description);
        this.put(DESCRIPTION, jaxbElement);
        return (T) this;
    }

    public T withRules(RetargetingListRuleItemMap... rules) {
        this.put(RULES, (rules == null) ? null : convert(rules, new BeanMapToBeanConverter()));
        return (T) this;
    }

    public T withRandomName() {
        this.put(NAME, "Name " + RandomStringUtils.randomAlphanumeric(5));
        return (T) this;
    }

    public T withRandomDescription() {
        this.put(DESCRIPTION, "Description " + RandomStringUtils.randomAlphanumeric(5));
        return (T) this;
    }

}
