package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import java.util.List;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.retargetinglists.AvailableForTargetsInAdGroupTypesArray;
import com.yandex.direct.api.v5.retargetinglists.ObjectFactory;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListScopeEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;

public class RetargetingListGetItemMap extends RetargetingListBaseMap<RetargetingListGetItemMap> {
    public static final String ID = "id";
    public static final String IS_AVAILABLE = "isAvailable";
    public static final String SCOPE = "scope";
    public static final String TYPE = "type";
    public static final String AVAILABLE_FOR_TARGETS_IN_ADGROUP_TYPES = "availableForTargetsInAdGroupTypes";

    public RetargetingListGetItemMap() {
        super();
        setBean(new RetargetingListGetItem());
    }

    public RetargetingListGetItemMap(RetargetingListGetItem retargetingListGetItemGetItem) {
        super();
        setBean(retargetingListGetItemGetItem);
    }

    public RetargetingListGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RetargetingListGetItemMap withId(long id) {
        this.put(ID, id);
        return this;
    }

    public RetargetingListGetItemMap withIsAvailable(YesNoEnum isAvailable) {
        this.put(IS_AVAILABLE, isAvailable);
        return this;
    }

    public RetargetingListGetItemMap withScope(RetargetingListScopeEnum scope) {
        this.put(SCOPE, scope);
        return this;
    }

    public RetargetingListGetItemMap withType(RetargetingListTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public RetargetingListGetItemMap withAvailableForTargetsInAdGroupTypes(List<AdGroupTypesEnum> groupTypes) {
        AvailableForTargetsInAdGroupTypesArray availableAdGroupTypes = new AvailableForTargetsInAdGroupTypesArray();
        availableAdGroupTypes.setItems(groupTypes);
        JAXBElement<AvailableForTargetsInAdGroupTypesArray> jaxbElement = new ObjectFactory()
                .createRetargetingListGetItemAvailableForTargetsInAdGroupTypes(availableAdGroupTypes);
        this.put(AVAILABLE_FOR_TARGETS_IN_ADGROUP_TYPES, jaxbElement);
        return this;
    }
}
