package ru.yandex.autotests.directapi.model.api5.retargetinglists;


import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleArgumentItem;
import org.apache.commons.lang3.RandomUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class RetargetingListRuleArgumentItemMap extends ModelBeanMap<RetargetingListRuleArgumentItemMap> {

    public static final String MEMBERSHIP_LIFE_SPAN = "membershipLifeSpan";
    public static final String EXTERNAL_ID = "externalId";
    public static final Integer MAX_MEMBERSHIP_LIFE_SPAN = 90;
    // TODO: обновить старую константу
    public static final Integer MAX_MEMBERSHIP_LIFE_SPAN_2019 = 540;
    public static final Integer DEFAULT_MEMBERSHIP_LIFE_SPAN = 45;
    public static final Integer MIN_MEMBERSHIP_LIFE_SPAN = 1;

    public RetargetingListRuleArgumentItemMap() {
        super();
        setBean(new RetargetingListRuleArgumentItem());
    }

    public RetargetingListRuleArgumentItemMap(RetargetingListRuleArgumentItem arguments) {
        super();
        setBean(arguments);
    }

    public RetargetingListRuleArgumentItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RetargetingListRuleArgumentItemMap withMembershipLifeSpan(Integer membershipLifeSpan) {
        this.put(MEMBERSHIP_LIFE_SPAN, membershipLifeSpan);
        return this;
    }

    public RetargetingListRuleArgumentItemMap withRandomMembershipLifeSpan() {
        this.put(MEMBERSHIP_LIFE_SPAN, RandomUtils.nextInt(MIN_MEMBERSHIP_LIFE_SPAN, MAX_MEMBERSHIP_LIFE_SPAN));
        return this;
    }

    public RetargetingListRuleArgumentItemMap withDefaultMembershipLifeSpan() {
        this.put(MEMBERSHIP_LIFE_SPAN, DEFAULT_MEMBERSHIP_LIFE_SPAN);
        return this;
    }

    public RetargetingListRuleArgumentItemMap withExternalId(long externalId) {
        this.put(EXTERNAL_ID, externalId);
        return this;
    }
}
