package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.apache.commons.lang.math.RandomUtils;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class RetargetingListRuleItemMap extends ModelBeanMap<RetargetingListRuleItemMap> {
    public static final String OPERATOR = "operator";
    public static final String ARGUMENTS = "arguments";
    public static final Integer MAX_AMOUNT_OF_ARGUMENTS = 250;

    public RetargetingListRuleItemMap() {
        super();
        setBean(new RetargetingListRuleItem());
    }

    public RetargetingListRuleItemMap(RetargetingListRuleItem rules) {
        super();
        setBean(rules);
    }

    public RetargetingListRuleItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RetargetingListRuleItemMap withArgumentItems(RetargetingListRuleArgumentItemMap... arguments) {
        this.put(ARGUMENTS, (arguments == null) ? null : convert(arguments, new BeanMapToBeanConverter()));
        return this;
    }

    public RetargetingListRuleItemMap withOperator(RetargetingListRuleOperatorEnum operator) {
        this.put(OPERATOR, operator);
        return this;
    }

    public RetargetingListRuleItemMap withRandomOperator() {
        RetargetingListRuleOperatorEnum[] operators = RetargetingListRuleOperatorEnum.values();
        this.put(OPERATOR, operators[RandomUtils.nextInt(operators.length)]);
        return this;
    }

}
