package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import java.util.Arrays;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListSelectionCriteria;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class RetargetingListSelectionCriteriaMap extends ModelBeanMap<RetargetingListSelectionCriteriaMap> {

    public static final String IDS = "ids";
    public static final String TYPES = "types";

    public RetargetingListSelectionCriteriaMap() {
        super();
        setBean(new RetargetingListSelectionCriteria());
    }

    public RetargetingListSelectionCriteriaMap(RetargetingListSelectionCriteria retargetingListSelectionCriteria) {
        super();
        setBean(retargetingListSelectionCriteria);
    }

    public RetargetingListSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RetargetingListSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }

    public RetargetingListSelectionCriteriaMap withTypes(RetargetingListTypeEnum... types) {
        this.put(TYPES, Arrays.asList(types));
        return this;
    }
}
