package ru.yandex.autotests.directapi.model.api5.retargetinglists;

import com.yandex.direct.api.v5.retargetinglists.UpdateRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class UpdateRequestMap extends ModelBeanMap<UpdateRequestMap> {
    public static final String RETARGETING_LISTS = "retargetingLists";
    public static final Integer MAX_AMOUNT_OF_IDS_IN_UPDATE_REQUEST = 1000;

    public UpdateRequestMap() {
        super();
        setBean(new UpdateRequest());
    }

    public UpdateRequestMap(UpdateRequest updateRequest) {
        super();
        setBean(updateRequest);
    }

    public UpdateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public UpdateRequestMap withRetargetingLists(RetargetingListUpdateItemMap... retargetingListUpdateItemMaps) {
        this.put(RETARGETING_LISTS, (retargetingListUpdateItemMaps == null)
                ? null : convert(retargetingListUpdateItemMaps, new BeanMapToBeanConverter()));
        return this;
    }
}
